
; CapaPlay ][ Unit for Assembler
;
; Syntax: call commandname C,parameters
; Value returned is either in dx:ax,ax or al depending on size

;****************************** GUS Settings **********************************

extrn _CP_GetIRQ:far				;byte
extrn _CP_SetIRQ:far				;(byte NewIRQ)
extrn _CP_GetDMA:far				;byte
extrn _CP_SetDMA:far				;(byte NewDMA)
extrn _CP_GetBasePort:far			;word
extrn _CP_SetBasePort:far			;(int NewBasePort)
extrn _CP_SetLineIn:far				;(byte LineInState)
extrn _CP_SetMicIn:far				;(byte MicInState)

;******************************* Load/Unload **********************************

extrn _CP_LoadModule:far			;byte (char *ModName,dword ReadPoint,byte TransferMode)
extrn _CP_LoadPatterns:far			;byte (char *ModName,dword ReadPoint,byte TransferMode)
extrn _CP_FreeModule:far

;***************************** Start/Stop/Pause *******************************

extrn _CP_StartModule:far			;(byte Amplification,byte DefaultPanning,byte TimerMode)
extrn _CP_StopModule:far	
extrn _CP_PauseModule:far

;********************** Set General Module Information ************************

extrn _CP_SetSpeedZeroMode:far			;(byte SpeedZeroMode)
extrn _CP_SetPanEffectMode:far			;(byte PanEffectMode)
extrn _CP_SetVBlankMode:far			;(byte VBlankMode)
extrn _CP_SetAmigaLimitsMode:far		;(byte AmigaLimitsMode)

;********************** Get General Module Information ************************

extrn _CP_GetModuleName:far			;dword pointer
extrn _CP_GetModuleType:far			;byte  
extrn _CP_GetModuleLength:far			;byte
extrn _CP_GetNumOfPatterns:far			;word
extrn _CP_GetNumOfInstruments:far		;byte
extrn _CP_GetNumOfChannels:far			;byte
extrn _CP_GetNumOfUsedChannels:far		;byte
extrn _CP_GetRestartPosition:far		;byte
extrn _CP_GetUsedPatternMemory:far		;dword
extrn _CP_GetUsedInstrumentInfoMemory:far	;dword
extrn _CP_GetUsedGUSMemory:far			;dword
extrn _CP_GetFileSize:far			;dword

;********************** Set General Playing Information ***********************

extrn _CP_SetPosition:far			;(int NewPosition)
extrn _CP_SetGlobalVolume:far			;(int NewVolume)
extrn _CP_SetSpeed:far				;(int NewSpeed)
extrn _CP_SetTempo:far				;(int NewTempo)
extrn _CP_RestoreSpeedAndTempo:far
extrn _CP_SetDefaultPanning:far			;(char DefaultPanning)

;********************** Get General Playing Information ***********************

extrn _CP_GetRow:far				;byte
extrn _CP_GetNumOfRows:far			;word (int PositionNum)
extrn _CP_GetPosition:far			;byte
extrn _CP_GetPattern:far			;byte
extrn _CP_GetGlobalVolume:far			;byte
extrn _CP_GetSpeed:far				;byte
extrn _CP_GetTempo:far				;byte
extrn _CP_GetPlayingTime:far			;word
extrn _CP_GetTimer:far				;dword
extrn _CP_GetLoopCounter:far			;byte

;************************* Set Channel Information ****************************

extrn _CP_SetChannelMute:far			;(byte int ChannelNum,byte MuteState)
extrn _CP_SetChannelPanning:far			;(int ChannelNum,byte NewPanning)
extrn _CP_PlaySample:far			;byte (byte ChannelNum,int InstrumentNum,int SampleNum,byte Note,byte Octave)
extrn _CP_StopSample:far			;byte (byte ChannelNum)

;************************* Get Channel Information ****************************

extrn _CP_GetChannelNote:far			;byte (int ChannelNum)
extrn _CP_GetChannelOctave:far			;byte (int ChannelNum)
extrn _CP_GetChannelVolume:far			;byte (int ChannelNum)
extrn _CP_GetChannelEffect:far			;byte (int ChannelNum)
extrn _CP_GetChannelEffectParams:far		;byte (int ChannelNum)
extrn _CP_GetChannelInstrument:far		;byte (int ChannelNum)
extrn _CP_GetChannelSample:far			;byte (int ChannelNum)
extrn _CP_GetChannelBar:far			;byte (int ChannelNum)
extrn _CP_GetChannelNoteTrigger:far		;byte (int ChannelNum)
extrn _CP_GetChannelPanning:far			;byte (int ChannelNum)
extrn _CP_GetChannelMute:far			;byte (int ChannelNum)

;******************** Set Instrument;Sample Information ***********************

extrn _CP_SetSampleMute				;byte (int InstrumentNum,int SampleNum,byte MuteState)

;******************** Get Instrument;Sample Information ***********************

extrn _CP_GetInstrumentName:far			;dword ptr (int InstrumentNum)
extrn _CP_GetNumOfSamples:far			;byte (int InstrumentNum)
extrn _CP_GetSampleName:far			;dword ptr (int InstrumentNum,int SampleNum)
extrn _CP_GetSampleSize:far			;dword (int InstrumentNum,int SampleNum)
extrn _CP_GetSampleC4Spd:far			;word(int InstrumentNum,int SampleNum)
extrn _CP_GetSampleVolume:far			;byte (int InstrumentNum,int SampleNum)
extrn _CP_GetSamplePanning:far			;byte (int InstrumentNum,int SampleNum)
extrn _CP_GetSampleLoopType:far			;byte (int InstrumentNum,int SampleNum)
extrn _CP_GetSampleLoopBegin:far		;dword (int InstrumentNum,int SampleNum)
extrn _CP_GetSampleLength:far			;dword (int InstrumentNum,int SampleNum)
extrn _CP_GetSample16Bit:far			;byte (int InstrumentNum,int SampleNum)
extrn _CP_GetSampleMute:far			;byte (int InstrumentNum,int SampleNum)

